//
//  MCReportModelAttributeBrowser.h
//  MCReporting
//
//  Created by Alykhan Jetha on 23/03/06.
//  Copyright 2006 Marketcircle Inc.. All rights reserved.
//

#import <MCApplication/MCWindowController.h>

@class MCReportModelBrowser;
@class MCReportElement;

@interface MCReportModelAttributeBrowser : MCWindowController {
	IBOutlet MCReportModelBrowser *browser;
	IBOutlet NSButton *okButton;
	
	NSArray *acceptableKinds;
	
	MCReportElement *reportElement;
	
	NSString *keypath;
	NSString *prefix;
	id (originalSource);
	
	
	id delegate;

}

- (void)setReportElement:(MCReportElement *)aReportElement;
- (void)setDelegate:(id)aDeleg;

- (NSArray *)acceptableKinds;
- (void)setAcceptableKinds:(NSArray *)anAcceptableKinds;

- (NSString *)keypath;
- (void)setKeypath:(NSString *)aKeypath;

- (NSString *)prefix;
- (void)setPrefix:(NSString *)aPrefix;

- (id)originalSource;
- (void)setOriginalSource:(id)anOriginalSource;

- (IBAction)ok:(id)sender;
- (IBAction)cancel:(id)sender;

@end


@interface NSObject (MCReportModelAttributeBrowserDelegate)
- (void)reportModelAttributeBrowser:(MCReportModelAttributeBrowser *)aBrowser 
				   didSelectKeyPath:(NSString *)aKeyPath prefix:(NSString *)aPrefix 
						 descriptor:(id)aDescript;
@end
